// PCanIsoTpExampleDlgAddNewMappings.cpp : implementation file
//

#include "stdafx.h"
#include "PCanIsoTpExampleDlgAddNewMappings.h"
#include "afxdialogex.h"


// CPCanIsoTpExampleDlgAddNewMappings dialog

IMPLEMENT_DYNAMIC(CPCanIsoTpExampleDlgAddNewMappings, CDialogEx)

CPCanIsoTpExampleDlgAddNewMappings::CPCanIsoTpExampleDlgAddNewMappings(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_PCANISOTPEXAMPLE_ADD_NEW_MAPPINGS, pParent)
{

}

CPCanIsoTpExampleDlgAddNewMappings::~CPCanIsoTpExampleDlgAddNewMappings()
{
}

void CPCanIsoTpExampleDlgAddNewMappings::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_RADIO_11BITS, radioButtonCanId11b);
	DDX_Control(pDX, IDC_RADIO_29BITS, radioButtonCanId29b);
	DDX_Control(pDX, IDC_COMBO_MESSAGE_TYPE, comboBoxMsgType);
	DDX_Control(pDX, IDC_COMBO_FORMAT_TYPE, comboBoxFormat);
	DDX_Control(pDX, IDC_COMBO_ADDRESSING_TYPE, comboBoxTargetType);
	DDX_Control(pDX, IDC_EDIT_CAN_ID, editCanID);
	DDX_Control(pDX, IDC_EDIT_CAN_ID_RESPONSE, editCanIdResp);
	DDX_Control(pDX, IDC_EDIT_SOURCE_ADDRESS, editSourceAddr);
	DDX_Control(pDX, IDC_EDIT_TARGET_ADDRESS, editTargetAddr);
	DDX_Control(pDX, IDC_EDIT_REMOTE_ADDRESS, editRemoteAddr);
	DDX_Control(pDX, IDC_SPIN_CAN_ID, numericUpDownCanId);
	DDX_Control(pDX, IDC_SPIN_CAN_ID_RESPONSE, numericUpDownCanIdResp);
	DDX_Control(pDX, IDC_SPIN_SOURCE_ADDRESS, numericUpDownSourceAddr);
	DDX_Control(pDX, IDC_SPIN_TARGET_ADDRESS, numericUpDownTargetAddr);
	DDX_Control(pDX, IDC_SPIN_REMOTE_ADDRESS, numericUpDownRemoteAddr);
	DDX_Control(pDX, ID_BUTTON_ADD_MAPPING, buttonCancel);
}


BEGIN_MESSAGE_MAP(CPCanIsoTpExampleDlgAddNewMappings, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_MESSAGE_TYPE, &CPCanIsoTpExampleDlgAddNewMappings::OnCbnSelchangeComboMessageType)
	ON_BN_CLICKED(ID_BUTTON_ADD_MAPPING, &CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedButtonAddMapping)
	ON_BN_CLICKED(ID_BUTTON_CANCEL_NEW_MAPPING, &CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedButtonCancelNewMapping)
	ON_BN_CLICKED(IDC_RADIO_11BITS, &CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedRadio11bits)
	ON_BN_CLICKED(IDC_RADIO_29BITS, &CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedRadio29bits)
	ON_CBN_SELCHANGE(IDC_COMBO_FORMAT_TYPE, &CPCanIsoTpExampleDlgAddNewMappings::OnCbnSelchangeComboFormatType)
	ON_CBN_SELCHANGE(IDC_COMBO_ADDRESSING_TYPE, &CPCanIsoTpExampleDlgAddNewMappings::OnCbnSelchangeComboAddressingType)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_CAN_ID, &CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinCanId)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_CAN_ID_RESPONSE, &CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinCanIdResponse)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_SOURCE_ADDRESS, &CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinSourceAddress)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_TARGET_ADDRESS, &CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinTargetAddress)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_REMOTE_ADDRESS, &CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinRemoteAddress)
	ON_EN_CHANGE(IDC_EDIT_CAN_ID, &CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditCanId)
	ON_EN_CHANGE(IDC_EDIT_CAN_ID_RESPONSE, &CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditCanIdResponse)
	ON_EN_CHANGE(IDC_EDIT_SOURCE_ADDRESS, &CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditSourceAddress)
	ON_EN_CHANGE(IDC_EDIT_TARGET_ADDRESS, &CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditTargetAddress)
	ON_EN_CHANGE(IDC_EDIT_REMOTE_ADDRESS, &CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditRemoteAddress)
END_MESSAGE_MAP()



/// <summary>
/// Populate Comboboxes "Message Type" and "Target Addressing Type"
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::PopulateComboBox() {
	// fill combobox "comboBox Message Type"
	for (UINT32 i = 0; i < m_listOfMsgType.size(); i++) {
		int indexMsgType = comboBoxMsgType.AddString(m_listOfMsgType[i].second);
		comboBoxMsgType.SetItemData(indexMsgType, m_listOfMsgType[i].first);
	}
	comboBoxMsgType.SetCurSel(comboBoxMsgType.FindStringExact(0, m_listOfMsgType[0].second));

	// fill combobox "comboBox Addressing Type"
	for (UINT32 i = 0; i < m_listOfAddrType.size(); i++) {
		int indexAddrType = comboBoxTargetType.AddString(m_listOfAddrType[i].second);
		comboBoxTargetType.SetItemData(indexAddrType, m_listOfAddrType[i].first);
	}
	comboBoxTargetType.SetCurSel(comboBoxTargetType.FindStringExact(0, m_listOfAddrType[0].second));
}


/// <summary>
/// Event handler called when selectin in comboBox "Message Type" is changed.
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnCbnSelchangeComboMessageType()
{
	// Updates comboBox "Format Addressing Type" contents:
	//  available format type is dependant of the can id type and the message type.
	FillComboBoxFormatType(GetSelectedIdType(), GetSelectedMsgType());
	OnCbnSelchangeComboFormatType();
	UpdateUi();
}

/// <summary>
/// Returns the selected CAN ID Type.
/// </summary>
/// <returns>The selected CAN ID Type (PCANTP_ID_CAN_11BIT if none is selected).</returns>
TPCANTPIdType CPCanIsoTpExampleDlgAddNewMappings::GetSelectedIdType()
{
	if (radioButtonCanId29b.GetCheck())
		return PCANTP_ID_CAN_29BIT;
	return PCANTP_ID_CAN_11BIT;
}

/// <summary>
/// Returns the selected ISO-TP Message Type.
/// </summary>
/// <returns>The selected ISO-TP Message Type (PCANTP_MESSAGE_UNKNOWN if none is selected).</returns>
TPCANTPMessageType CPCanIsoTpExampleDlgAddNewMappings::GetSelectedMsgType()
{
	if (comboBoxMsgType.GetItemData(comboBoxMsgType.GetCurSel()) == PCANTP_MESSAGE_DIAGNOSTIC)
		return PCANTP_MESSAGE_DIAGNOSTIC;
	return PCANTP_MESSAGE_REMOTE_DIAGNOSTIC;
}


/// <summary>
/// Fills the comboBox "Format Type" based on pre-selected inputs.
/// </summary>
/// <param name="idType">CAN ID Type of the mapping.</param>
/// <param name="msgType">Message Type of the mapping.</param>
void CPCanIsoTpExampleDlgAddNewMappings::FillComboBoxFormatType(TPCANTPIdType p_idType, TPCANTPMessageType p_msgType)
{
	int index = 0;

	comboBoxFormat.ResetContent();
	// Fills format type combobox.
	switch (p_msgType)
	{
	case PCANTP_MESSAGE_REMOTE_DIAGNOSTIC:
		// Reminder: PCANTP_FORMAT_MIXED does NOT require mappings with 29 bits CAN ID.
		if (p_idType == PCANTP_ID_CAN_11BIT)
		{
			index = comboBoxFormat.AddString(L"PCANTP_FORMAT_MIXED");
			comboBoxFormat.SetItemData(index, PCANTP_FORMAT_MIXED);
			comboBoxFormat.SetCurSel(comboBoxFormat.FindStringExact(0, L"PCANTP_FORMAT_MIXED"));
		}
		break;
	case PCANTP_MESSAGE_DIAGNOSTIC:
	default:
		index = comboBoxFormat.AddString(L"PCANTP_FORMAT_NORMAL");
		comboBoxFormat.SetItemData(index, PCANTP_FORMAT_NORMAL);

		index = comboBoxFormat.AddString(L"PCANTP_FORMAT_EXTENDED");
		comboBoxFormat.SetItemData(index, PCANTP_FORMAT_EXTENDED);

		comboBoxFormat.SetCurSel(comboBoxFormat.FindStringExact(0, L"PCANTP_FORMAT_NORMAL"));
		// Reminder: PCANTP_FORMAT_FIXED_NORMAL does NOT require mappings.
		break;
	}
}

/// <summary>
/// Event handler called when Button Add Mapping is clicked
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedButtonAddMapping()
{
	EndDialog(CheckMapping());
}


/// <summary>
/// Event handler called when Button Cancel is clicked
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedButtonCancelNewMapping()
{
	EndDialog(IDCANCEL);
}

/// <summary>
/// Returns the selected ISO-TP Format Type.
/// </summary>
/// <returns>The selected ISO-TP Format Type (PCANTP_FORMAT_UNKNOWN if none is selected).</returns>
TPCANTPFormatType CPCanIsoTpExampleDlgAddNewMappings::GetSelectedFormatType()
{
	if (comboBoxFormat.GetCurSel() == CB_ERR)
		return PCANTP_FORMAT_UNKNOWN;
	return (TPCANTPFormatType)comboBoxFormat.GetItemData(comboBoxFormat.GetCurSel());
}
/// <summary>
/// Returns the selected ISO-TP Target Addressing Type.
/// </summary>
/// <returns>The selected ISO-TP Target Addressing Type (PCANTP_ADDRESSING_UNKNOWN if none is selected).</returns>
TPCANTPAddressingType CPCanIsoTpExampleDlgAddNewMappings::GetSelectedTargetType()
{
	if (comboBoxTargetType.GetCurSel() == CB_ERR)
		return PCANTP_ADDRESSING_UNKNOWN;
	return (TPCANTPAddressingType)comboBoxTargetType.GetItemData(comboBoxTargetType.GetCurSel());
}

/// <summary>
/// Event handler called when Radio Button 11 Bits is clicked
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedRadio11bits()
{
	UINT32 maxCanID = 0x1FFFFFFF;
	CString strMaxCanID = L"0x1FFFFFFF";
	// Updates maximum CAN ID values.
	if (radioButtonCanId11b.GetCheck())
	{
		maxCanID = 0x7FF;
		strMaxCanID = L"0x7FF";
	}

	OnCbnSelchangeComboMessageType();
	numericUpDownCanId.SetRange32(0, maxCanID);
	//editCanID.SetWindowTextW(strMaxCanID);
	numericUpDownCanIdResp.SetRange32(0, maxCanID);

	// Updates comboBox "Format Addressing Type" contents:
	//  available format type is dependant of the can id type and the message type
	FillComboBoxFormatType(GetSelectedIdType(), GetSelectedMsgType());
	UpdateUi();
}


/// <summary>
/// Event handler called when Radio Button 29 bits is clicked
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnBnClickedRadio29bits()
{
	OnBnClickedRadio11bits();
}

/// <summary>
/// Checks consistency of components selection.
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::UpdateUi()
{
	// Note: we do not update the member "Enabled" of UI components directly
	// to prevent flickering.
	bool radioButtonCanId11b_Enabled = true;
	bool radioButtonCanId29b_Enabled = true;
	bool comboBoxMsgType_Enabled = false;
	bool comboBoxFormat_Enabled = false;
	bool comboBoxTargetType_Enabled = false;
	bool numericUpDownCanId_Enabled = false;
	bool numericUpDownCanIdResp_Enabled = false;
	bool numericUpDownSourceAddr_Enabled = false;
	bool numericUpDownTargetAddr_Enabled = false;
	bool numericUpDownRemoteAddr_Enabled = false;

	// Dialog must be created
	if (NULL == radioButtonCanId11b)
		return;
	// Dialog must be initialized
	if (!IsWindow(radioButtonCanId11b))
		return;
	// ID type must be set to continue
	if (!radioButtonCanId11b.GetCheck() && !radioButtonCanId29b.GetCheck())
		return;
	comboBoxMsgType_Enabled = true;
	// Message type must be set to continue
	if (GetSelectedMsgType() != PCANTP_MESSAGE_UNKNOWN)
	{
		switch (GetSelectedMsgType())
		{
		case PCANTP_MESSAGE_REMOTE_DIAGNOSTIC:
			numericUpDownRemoteAddr_Enabled = true;
			break;
		case PCANTP_MESSAGE_DIAGNOSTIC:
			// do NOT enable remote address
			numericUpDownRemoteAddr.SetPos32(0x00);
			editRemoteAddr.SetWindowTextW(L"0x00");
			m_remoteAddr = 0;
			break;
		}
		comboBoxFormat_Enabled = true;
		// Format type must be set to continue
		if (GetSelectedFormatType() != PCANTP_FORMAT_UNKNOWN)
		{
			comboBoxTargetType_Enabled = true;
			// Target type must be set to continue
			if (GetSelectedTargetType() != PCANTP_ADDRESSING_UNKNOWN)
			{
				switch (GetSelectedTargetType())
				{
				case PCANTP_ADDRESSING_FUNCTIONAL:
					// do NOT enable CAN ID response
					break;
				case PCANTP_ADDRESSING_PHYSICAL:
					numericUpDownCanIdResp_Enabled = true;
					break;
				}
				numericUpDownCanId_Enabled = true;
				numericUpDownSourceAddr_Enabled = true;
				numericUpDownTargetAddr_Enabled = true;
			}
		}
	}
	// Updates components (only if initialization is OK)
	if (IsWindow(radioButtonCanId11b)) radioButtonCanId11b.EnableWindow(radioButtonCanId11b_Enabled);
	if (IsWindow(radioButtonCanId29b)) radioButtonCanId29b.EnableWindow(radioButtonCanId29b_Enabled);
	if (IsWindow(comboBoxMsgType)) comboBoxMsgType.EnableWindow(comboBoxMsgType_Enabled);
	if (IsWindow(comboBoxFormat)) comboBoxFormat.EnableWindow(comboBoxFormat_Enabled);
	if (IsWindow(comboBoxTargetType)) comboBoxTargetType.EnableWindow(comboBoxTargetType_Enabled);
	if (IsWindow(numericUpDownCanId)) numericUpDownCanId.EnableWindow(numericUpDownCanId_Enabled);
	if (IsWindow(numericUpDownCanIdResp)) numericUpDownCanIdResp.EnableWindow(numericUpDownCanIdResp_Enabled);
	if (IsWindow(numericUpDownSourceAddr)) numericUpDownSourceAddr.EnableWindow(numericUpDownSourceAddr_Enabled);
	if (IsWindow(numericUpDownTargetAddr)) numericUpDownTargetAddr.EnableWindow(numericUpDownTargetAddr_Enabled);
	if (IsWindow(numericUpDownRemoteAddr)) numericUpDownRemoteAddr.EnableWindow(numericUpDownRemoteAddr_Enabled);
	if (IsWindow(editCanID)) editCanID.EnableWindow(numericUpDownCanId_Enabled);
	if (IsWindow(editCanIdResp)) editCanIdResp.EnableWindow(numericUpDownCanIdResp_Enabled);
	if (IsWindow(editSourceAddr)) editSourceAddr.EnableWindow(numericUpDownSourceAddr_Enabled);
	if (IsWindow(editTargetAddr)) editTargetAddr.EnableWindow(numericUpDownTargetAddr_Enabled);
	if (IsWindow(editRemoteAddr)) editRemoteAddr.EnableWindow(numericUpDownRemoteAddr_Enabled);
	UpdateAddNewMappingButton();
}

/// <summary>
/// Event handler called when selection in comboBox "Format Type" is changed.
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnCbnSelchangeComboFormatType()
{
	// Unless Format Mixed is selected, Remote Address is disabled.
	if (GetSelectedFormatType() == PCANTP_FORMAT_MIXED)
	{
		numericUpDownRemoteAddr.EnableWindow(TRUE);
		editRemoteAddr.EnableWindow(TRUE);
	}
	else
	{
		numericUpDownRemoteAddr.EnableWindow(FALSE);
		editRemoteAddr.EnableWindow(FALSE);
		numericUpDownRemoteAddr.SetPos32(0x00);
		m_remoteAddr = 0;
	}
	OnCbnSelchangeComboAddressingType();
	UpdateUi();
}


/// <summary>
/// Event handler called when selection in comboBox "Addressing Type" is changed.
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnCbnSelchangeComboAddressingType()
{
	// Can Id Response is not used if Functional Addressing is selected.
	if (GetSelectedTargetType() == PCANTP_ADDRESSING_FUNCTIONAL)
	{
		numericUpDownCanIdResp.SetRange32(CAN_ID_NO_MAPPING, CAN_ID_NO_MAPPING);
		numericUpDownCanIdResp.SetPos32(CAN_ID_NO_MAPPING);
		m_canIdResponse = CAN_ID_NO_MAPPING;
		numericUpDownCanIdResp.EnableWindow(FALSE);
		editCanIdResp.EnableWindow(FALSE);
	}
	else
	{
		INT32 minRange32 = 0;
		INT32 maxRange32 = 0;
		numericUpDownCanId.GetRange32(minRange32, maxRange32);
		numericUpDownCanIdResp.SetRange32(minRange32, maxRange32);
		
		numericUpDownCanIdResp.EnableWindow(TRUE);
		editCanIdResp.EnableWindow(TRUE);
		
		numericUpDownTargetAddr.EnableWindow(TRUE);
		editTargetAddr.EnableWindow(TRUE);
	}
	UpdateUi();
}

/// <summary>
/// Checks that all the values for the mapping are filled in.
/// </summary>
/// <returns>IDOK if the values are set, IDCANCEL otherwise</returns>
INT_PTR CPCanIsoTpExampleDlgAddNewMappings::CheckMapping()
{
	// get mapping values
	m_canIdType = GetSelectedIdType();
	m_msgType = GetSelectedMsgType();
	m_formatType = GetSelectedFormatType();
	m_targetType = GetSelectedTargetType();
	m_canIdResponse = numericUpDownCanIdResp.GetPos32();
	m_canId = numericUpDownCanId.GetPos32();
	m_sourceAddr = numericUpDownSourceAddr.GetPos32();
	m_targetAddr = numericUpDownTargetAddr.GetPos32();
	m_remoteAddr = numericUpDownRemoteAddr.GetPos32();

	// check comboboxes selection
	if (m_msgType == PCANTP_MESSAGE_UNKNOWN)
		return IDCANCEL;
	if (m_formatType == PCANTP_FORMAT_UNKNOWN)
		return IDCANCEL;
	if (m_targetType == PCANTP_ADDRESSING_UNKNOWN)
		return IDCANCEL;

	// Functional addressing is a one way communication,
	// there is no need to check the target 
	if (m_targetType != PCANTP_ADDRESSING_FUNCTIONAL)
	{
		// source and target addresses should not be the same
		// thus it is the same for the CAN IDs 
		if (m_sourceAddr == m_targetAddr || m_canId == m_canIdResponse)
			return IDCANCEL;
	}
	return IDOK;
}


/// <summary>
/// Manage Spin value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinCanId(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	INT32 upper = 0;
	INT32 lower = 0;
	m_canId = pNMUpDown->iDelta + pNMUpDown->iPos;
	numericUpDownCanId.GetRange32(lower, upper);
	if ((INT32)m_canId < (INT32)lower) m_canId = (INT32)lower;
	if ((INT32)m_canId > (INT32)upper) m_canId = (INT32)upper;
	UpdateAddNewMappingButton();
	*pResult = 0;
}

/// <summary>
/// Manage Spin value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinCanIdResponse(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	INT32 upper = 0;
	INT32 lower = 0;
	m_canIdResponse = pNMUpDown->iDelta + pNMUpDown->iPos;
	numericUpDownCanIdResp.GetRange32(lower, upper);
	if ((INT32)m_canIdResponse < (INT32)lower) m_canIdResponse = (INT32)lower;
	if ((INT32)m_canIdResponse > (INT32)upper) m_canIdResponse = (INT32)upper;
	UpdateAddNewMappingButton();
	*pResult = 0;
}


/// <summary>
/// Manage Spin value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinSourceAddress(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	INT32 upper = 0;
	INT32 lower = 0;
	m_sourceAddr = pNMUpDown->iDelta + pNMUpDown->iPos;
	numericUpDownSourceAddr.GetRange32(lower, upper);
	if ((INT32)m_sourceAddr < (INT32)lower) m_sourceAddr = (INT32)lower;
	if ((INT32)m_sourceAddr > (INT32)upper) m_sourceAddr = (INT32)upper;
	UpdateAddNewMappingButton();
	*pResult = 0;
}


/// <summary>
/// Manage Spin value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinTargetAddress(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	INT32 upper = 0;
	INT32 lower = 0;
	m_targetAddr = pNMUpDown->iDelta + pNMUpDown->iPos;
	numericUpDownTargetAddr.GetRange32(lower, upper);
	if ((INT32)m_targetAddr < (INT32)lower) m_targetAddr = (INT32)lower;
	if ((INT32)m_targetAddr > (INT32)upper) m_targetAddr = (INT32)upper;
	UpdateAddNewMappingButton();
	*pResult = 0;
}


/// <summary>
/// Manage Spin value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnDeltaposSpinRemoteAddress(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	INT32 upper = 0;
	INT32 lower = 0;
	m_remoteAddr = pNMUpDown->iDelta + pNMUpDown->iPos;
	numericUpDownRemoteAddr.GetRange32(lower, upper);
	if ((INT32)m_remoteAddr < (INT32)lower) m_remoteAddr = (INT32)lower;
	if ((INT32)m_remoteAddr > (INT32)upper) m_remoteAddr = (INT32)upper;
	UpdateAddNewMappingButton();
	*pResult = 0;
}


BOOL CPCanIsoTpExampleDlgAddNewMappings::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	CenterWindow(); // Centers the modal dialog to the parent dialog

	numericUpDownCanId.SetBase(16);
	numericUpDownCanId.SetRange32(0, 0x7FF);
	numericUpDownCanId.SetPos32(0x00);
	m_canId = 0;

	numericUpDownCanIdResp.SetBase(16);
	numericUpDownCanIdResp.SetRange32(0, 0x7FF);
	numericUpDownCanIdResp.SetPos32(0x00);
	m_canIdResponse = 0;

	numericUpDownRemoteAddr.SetBase(16);
	numericUpDownRemoteAddr.SetRange32(0, 0x7FF);
	numericUpDownRemoteAddr.SetPos32(0x00);
	m_remoteAddr = 0;

	numericUpDownSourceAddr.SetBase(16);
	numericUpDownSourceAddr.SetRange32(0, 0x7FF);
	numericUpDownSourceAddr.SetPos32(0x00);
	m_sourceAddr = 0;

	numericUpDownTargetAddr.SetBase(16);
	numericUpDownTargetAddr.SetRange32(0, 0x7FF);
	numericUpDownTargetAddr.SetPos32(0x00);
	m_targetAddr = 0;

	// Initialize and update UI
	radioButtonCanId11b.SetCheck(true);
	PopulateComboBox(); // Populates the static values of ComboBox
	FillComboBoxFormatType(GetSelectedIdType(), GetSelectedMsgType());
	OnCbnSelchangeComboMessageType();
	numericUpDownCanIdResp.SetPos32(m_canIdResponse);
	numericUpDownSourceAddr.SetPos32(m_sourceAddr);
	numericUpDownTargetAddr.SetPos32(m_targetAddr);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}


/// <summary>
/// Manage edit buddy's value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditCanId()
{
	CString textValue = L"";
	if (IsWindow(editCanID))
	{
		editCanID.GetWindowTextW(textValue);
		numericUpDownCanId.SetPos32(CPCanIsoTpUtils::HexStrToDec(textValue));
		UpdateAddNewMappingButton();
	}
}


/// <summary>
/// Manage edit buddy's value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditCanIdResponse()
{
	CString textValue = L"";
	if (IsWindow(editCanIdResp))
	{
		editCanIdResp.GetWindowTextW(textValue);
		numericUpDownCanIdResp.SetPos32(CPCanIsoTpUtils::HexStrToDec(textValue));
		UpdateAddNewMappingButton();
	}
}


/// <summary>
/// Manage edit buddy's value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditSourceAddress()
{
	CString textValue = L"";
	if (IsWindow(editSourceAddr))
	{
		editSourceAddr.GetWindowTextW(textValue);
		numericUpDownSourceAddr.SetPos32(CPCanIsoTpUtils::HexStrToDec(textValue));
		UpdateAddNewMappingButton();
	}
}

/// <summary>
/// Manage edit buddy's value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::UpdateAddNewMappingButton()
{
	if (CheckMapping() == IDOK)
	{
		if (IsWindow(buttonCancel)) buttonCancel.EnableWindow(true);
	}
	else
	{
		if (IsWindow(buttonCancel)) buttonCancel.EnableWindow(false);
	}
}

/// <summary>
/// Manage edit buddy's value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditTargetAddress()
{
	CString textValue = L"";
	if (IsWindow(editTargetAddr))
	{
		editTargetAddr.GetWindowTextW(textValue);
		numericUpDownTargetAddr.SetPos32(CPCanIsoTpUtils::HexStrToDec(textValue));
		UpdateAddNewMappingButton();
	}
}


/// <summary>
/// Manage edit buddy's value
/// </summary>
void CPCanIsoTpExampleDlgAddNewMappings::OnEnChangeEditRemoteAddress()
{
	CString textValue = L"";
	if (IsWindow(editRemoteAddr))
	{
		editRemoteAddr.GetWindowTextW(textValue);
		numericUpDownRemoteAddr.SetPos32(CPCanIsoTpUtils::HexStrToDec(textValue));
		UpdateAddNewMappingButton();
	}
}
